// SphSimulation.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

using namespace std;

int _tmain(int argc, _TCHAR* argv[])
{
	srand(time(NULL));

	int i;
	cout << "======================================" << endl;
	cout << "Smooth Particle Hydrodynamics" << endl;
	cout << "bartosz.k.gdz[at]gmail.com" << endl;
	cout << "======================================" << endl << endl;

	ifstream config;
	config.open("config.cfg");
	if (config.good())
	{
		//Declaration of constants for environments
		int environmentsQuantity = 1;

		long int * particlesQuantity = new long int[environmentsQuantity];
		float * mass = new float[environmentsQuantity];
		float * density = new float[environmentsQuantity];
		float * pressure = new float[environmentsQuantity];
		float * k = new float[environmentsQuantity];
		string * name = new string[environmentsQuantity];
		int frames;
		int qVessle;

		config >> frames;


		//TODO: czytanie stalych z pliku
		for (int i = 0; i < environmentsQuantity; i++)
		{
			config >> particlesQuantity[i];
			mass[i] = 3.4e-5; //masa kropli??? //3.0e-10; //start 3.0e-10
			density[i] = 1000;
			pressure[i] = 100000; // Pa //10;
			k[i] = 1;
			name[i] = "H2O";
		}


		config >> qVessle;

		//TODO: polozenie poczatkowe kazdej czasteczki z kazdego osrodka jako argument wejsciowy
		Model<float> model(environmentsQuantity,  //quantity			of environments
			particlesQuantity,	  //table of quantities of particles in environments
			mass,				  //table of masses     of particles in environments
			density,				  //table of densities  of environments
			pressure,			  //table of pressure   of environments
			k,					  //table of cp/cv      of environments
			name,					  //table of names      of environments
			frames,                    //quantity of frames
			qVessle
			);

		config.close();
		//cout << model;
		//_getch();

		system("SPH.exe");
		return 0;
	}
	else
	{
		cout << "Cannot open config file.";
		return -1;
	}
}

